% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badges.R
\name{create_badge}
\alias{create_badge}
\title{Create an SVG Badge}
\usage{
create_badge(
  label,
  value,
  color,
  font = "Jost",
  style = "margin:2px;",
  fontsize = 11,
  horiz_padding = 5,
  extra_right_pad = 2,
  class = "",
  shadow_offset = 2,
  corner_radius = 3,
  height = NULL,
  as_string = TRUE
)
}
\arguments{
\item{label}{Label text (left side)}

\item{value}{Value text (right side)}

\item{color}{Background color for value area}

\item{font}{Font family name}

\item{style}{CSS style string}

\item{fontsize}{Font size in pixels}

\item{horiz_padding}{Horizontal padding}

\item{extra_right_pad}{Extra padding on right side}

\item{class}{CSS class}

\item{shadow_offset}{Shadow offset in pixels}

\item{corner_radius}{Corner radius for rounded rectangle}

\item{height}{Minimum height (optional)}

\item{as_string}{Return as character string}
}
\value{
SVG string
}
\description{
Generate a badge similar to shields.io style with label and value.
Both sides have properly rounded corners.
}
\examples{
create_badge("UH", "192", "white")
create_badge("Recurso Federal", "36,4 milhões", "#4CAF50")
}
