% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logos.R
\name{load_svg_for_embed}
\alias{load_svg_for_embed}
\title{Load and process external SVG file for embedding}
\usage{
load_svg_for_embed(svg_path, target_height = 40, target_width = NULL)
}
\arguments{
\item{svg_path}{Path to the SVG file}

\item{target_height}{Desired height in pixels}

\item{target_width}{Optional desired width (calculated from aspect ratio if NULL)}
}
\value{
A list with svg_content, width, and height
}
\description{
Reads an SVG file and processes it to be embedded inside another SVG.
Removes XML declarations, adjusts dimensions, and prepares for embedding.
}
\details{
This function is useful when you want to embed custom logos or icons in cards.
You can pass any SVG file path to the \code{logos}, \code{bottom_logos}, or \code{with_icon}
parameters of \code{svg_card()}.
}
\examples{
\dontrun{ # Need a external svg file
# Load a custom logo
logo <- load_svg_for_embed("/path/to/logo.svg", target_height = 40)

# Or just pass the path directly to svg_card():
svg_card(
  title = "My Card",
  logos = c("/path/to/logo1.svg", "/path/to/logo2.svg"),
  ...
)
}
}
