% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{caugi_options}
\alias{caugi_options}
\title{Get or set global options for caugi}
\usage{
caugi_options(...)
}
\arguments{
\item{...}{Named values to update options with, or unnamed option names to
retrieve. To query all options, call without arguments.}
}
\value{
When setting, returns (invisibly) the previous values for the updated
options. When getting (no arguments or unnamed character vector), returns
the requested options.
}
\description{
Configure global defaults for caugi, including plot composition spacing and
default visual styles for nodes, edges, labels, and titles.
}
\details{
Currently supported options are nested under the \code{plot} key:
\itemize{
\item \code{spacing}: A \code{\link[grid:unit]{grid::unit()}} controlling space between composed plots
(default: \code{grid::unit(1, "lines")})
\item \code{node_style}: List of default node appearance parameters:
\itemize{
\item \code{fill}: Fill color (default: \code{"lightgrey"})
\item \code{padding}: Padding around labels in mm (default: \code{2})
\item \code{size}: Size multiplier (default: \code{1})
}
\item \code{edge_style}: List of default edge appearance parameters:
\itemize{
\item \code{arrow_size}: Arrow size in mm (default: \code{3})
\item \code{circle_size}: Radius of endpoint circles for partial edges in mm (default: \code{1.5})
\item \code{fill}: Arrow/line color (default: \code{"black"})
}
\item \code{label_style}: List of label text parameters (see \code{\link[grid:gpar]{grid::gpar()}})
\item \code{title_style}: List of title text parameters:
\itemize{
\item \code{col}: Text color (default: \code{"black"})
\item \code{fontface}: Font face (default: \code{"bold"})
\item \code{fontsize}: Font size in pts (default: \code{14.4})
}
}

Options set via \code{caugi_options()} serve as global defaults that can be
overridden by arguments to \code{\link[=plot]{plot()}}.
}
\examples{
# Query all options
caugi_options()

# Query specific option
caugi_options("plot")

# Set plot spacing
caugi_options(plot = list(spacing = grid::unit(2, "lines")))

# Set default node style
caugi_options(plot = list(
  node_style = list(fill = "lightblue", padding = 3)
))

# Set multiple options at once
caugi_options(plot = list(
  spacing = grid::unit(1.5, "lines"),
  node_style = list(fill = "lightblue", padding = 3),
  edge_style = list(arrow_size = 4, fill = "darkgray"),
  title_style = list(col = "blue", fontsize = 16)
))

# Reset to defaults
caugi_options(caugi_default_options())

}
\seealso{
\code{\link[=plot]{plot()}} for per-plot style arguments, \code{\link[grid:gpar]{grid::gpar()}} for
available graphical parameters
}
\concept{options}
