% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-conversions.R
\name{as_bnlearn_knowledge}
\alias{as_bnlearn_knowledge}
\title{Convert Knowledge to bnlearn Knowledge}
\usage{
as_bnlearn_knowledge(kn)
}
\arguments{
\item{kn}{A \code{knowledge} object.  Must have no tier information.}
}
\value{
A list with two elements, \code{whitelist} and \code{blacklist}, each a data
frame containing the edges in a \code{from}, \code{to} format.
}
\description{
Converts a \code{Knowledge} object to a list of two data frames, namely
\code{whitelist} and \code{blacklist}, which can be used as arguments for
\pkg{bnlearn} algorithms. The \code{whitelist} contains all required edges, and the
\code{blacklist} contains all forbidden edges. Tiers will be made into forbidden
edges before running the conversion.
}
\examples{
# produce whitelist/blacklist data frame for bnlearn
data(tpc_example)

kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    oldage ~ starts_with("old")
  ),
  child_x1 \%-->\% youth_x3
)

bnlearn_kn <- as_bnlearn_knowledge(kn)
print(bnlearn_kn)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
