% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-verbs.R
\name{convert_tiers_to_forbidden}
\alias{convert_tiers_to_forbidden}
\title{Convert Tiered Knowledge to Forbidden Knowledge}
\usage{
convert_tiers_to_forbidden(kn)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}
}
\value{
A \code{Knowledge} object with forbidden edges added, tiers removed.
}
\description{
Converts tier assignments into forbidden edges, and drops tiers in the output.
}
\examples{
kn <- knowledge(
 tpc_example,
 tier(
  child ~ starts_with("child"),
  youth ~ starts_with("youth"),
  old ~ starts_with("old")
 )
)
kn_converted <- convert_tiers_to_forbidden(kn)
print(kn_converted)
plot(kn_converted)

}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
