% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-verbs.R
\name{unfreeze}
\alias{unfreeze}
\title{Unfreeze a Knowledge Object.}
\usage{
unfreeze(kn)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}
}
\value{
The same \code{Knowledge} object with the \code{frozen} attribute set to
\code{FALSE}.
}
\description{
This allows you to add new variables to the \code{Knowledge} object,
even though it was frozen earlier by adding a data frame to the knowledge
constructor \code{knowledge()}.
}
\examples{
# unfreeze allows adding variables beyond the original data frame columns
data(tpc_example)

kn <- knowledge(tpc_example)

# this would error while frozen
try(add_vars(kn, "new_var"))

# unfreeze and add the new variable successfully
kn <- unfreeze(kn)
kn <- add_vars(kn, "new_var")

print(kn)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()}
}
\concept{knowledge}
\concept{knowledge functions}
