% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_submission.R
\name{compare_submission}
\alias{compare_submission}
\title{Batch Compare CDISC Datasets Across Submission Directories}
\usage{
compare_submission(
  base_dir,
  compare_dir,
  format = NULL,
  id_vars = NULL,
  tolerance = 0,
  output_file = NULL
)
}
\arguments{
\item{base_dir}{Path to directory containing base/reference files.}

\item{compare_dir}{Path to directory containing comparison files.}

\item{format}{File format to match: "xpt", "sas7bdat", "csv", or "rds".
When NULL (default), auto-detected from the most common file type in base_dir.}

\item{id_vars}{Optional character vector of ID variables (passed to each comparison).
When NULL, CDISC-standard keys are auto-detected per domain.}

\item{tolerance}{Numeric tolerance for floating-point comparisons (default 0).}

\item{output_file}{Optional path to Excel (.xlsx) file for consolidated report.}
}
\value{
Named list of cdisc_compare() results, one per matched domain.
}
\description{
Scans two directories for matching dataset files, runs \code{\link[=cdisc_compare]{cdisc_compare()}}
on each pair, and optionally generates a consolidated Excel report.
}
\examples{
\dontrun{
  # Auto-detects format from directory contents
  results <- compare_submission("v1/", "v2/",
                                 output_file = "submission_diff.xlsx")

  # Explicit format
  results <- compare_submission("v1/", "v2/", format = "csv")
}

}
