\name{acef_ii_cardiac_surgery}
\alias{acef_ii_cardiac_surgery}
\title{
ACEF II Risk Score for Cardiac Surgery
}
\description{
Calculates the ACEF II (Age, Creatinine, Ejection Fraction II) Risk Score to predict 30-day operative mortality in patients undergoing elective or emergency cardiac surgery. This updated version of the original ACEF score incorporates emergency status and preoperative anemia (hematocrit).
}
\usage{
acef_ii_cardiac_surgery(age, ejection_fraction, creatinine_mg_dl,
                        hematocrit, emergency_surgery)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{ejection_fraction}{
Numeric. Left ventricular ejection fraction in percentage (e.g., 50 for 50\%).
}
  \item{creatinine_mg_dl}{
Numeric. Serum creatinine level in mg/dL. (Score adds 2.0 points if > 2.0 mg/dL).
}
  \item{hematocrit}{
Numeric. Preoperative hematocrit in percentage (e.g., 38 for 38\%). (Score adds 0.2 points for each percentage point below 36\%).
}
  \item{emergency_surgery}{
Numeric (0 or 1). 1 if surgery is emergency (required before the beginning of the next working day), 0 otherwise. (Score adds 3.0 points if Yes).
}
}
\value{
A list containing:
\item{ACEF_II_Score}{The calculated risk score.}
\item{Interpretation}{General prognostic guidance.}
}
\references{
Ranucci M, Castelvecchio S, Menicanti L, et al. The ACEF II Risk Score for cardiac surgery: updated but still parsimonious. Eur Heart J. 2018;39(23):2183-2189. doi:10.1093/eurheartj/ehx039
}
\examples{

# Example 1: Low Risk
# 65yo, EF 55\%, Cr 1.0, Hct 40\%, Elective
# Score = 65/55 = 1.18
acef_ii_cardiac_surgery(65, 55, 1.0, 40, 0)

# Example 2: High Risk
# 75yo, EF 30\%, Cr 2.5, Hct 30\%, Emergency
# Score = (75/30) + 2.0 + 3.0 + (0.2 * (36-30))
#       = 2.5 + 2.0 + 3.0 + 1.2 = 8.7
acef_ii_cardiac_surgery(75, 30, 2.5, 30, 1)
}
