\name{catch_head_injury_rule}
\alias{catch_head_injury_rule}
\title{
CATCH Rule (Canadian Assessment of Tomography for Childhood Head Injury)
}
\description{
Applies the CATCH Rule to determine the need for CT imaging in children with minor head injury. The rule stratifies patients into High Risk (need for neurological intervention) and Medium Risk (potential brain injury on CT).
}
\usage{
catch_head_injury_rule(gcs_lt_15_2hr, suspected_open_skull_fx, worsening_headache,
                       irritability, basal_skull_fx_signs, large_boggy_hematoma,
                       dangerous_mechanism)
}
\arguments{
  \item{gcs_lt_15_2hr}{
Numeric (0 or 1). GCS < 15 at 2 hours after injury. (High Risk Factor).
}
  \item{suspected_open_skull_fx}{
Numeric (0 or 1). Suspected open or depressed skull fracture. (High Risk Factor).
}
  \item{worsening_headache}{
Numeric (0 or 1). History of worsening headache. (High Risk Factor).
}
  \item{irritability}{
Numeric (0 or 1). Irritability on examination. (High Risk Factor).
}
  \item{basal_skull_fx_signs}{
Numeric (0 or 1). Any sign of basal skull fracture (e.g., raccoon eyes, Battle's sign, hemotympanum, otorrhea/rhinorrhea). (Medium Risk Factor).
}
  \item{large_boggy_hematoma}{
Numeric (0 or 1). Large, boggy hematoma of the scalp. (Medium Risk Factor).
}
  \item{dangerous_mechanism}{
Numeric (0 or 1). Dangerous mechanism of injury (e.g., MVA, fall from height >3ft or 5 stairs, bicycle w/o helmet). (Medium Risk Factor).
}
}
\value{
A list containing:
\item{Risk_Level}{"High Risk", "Medium Risk", or "Low Risk".}
\item{Recommendation}{Clinical guidance on CT imaging necessity.}
}
\references{
Osmond MH, Klassen TP, Wells GA, et al. CATCH: a clinical decision rule for the use of computed tomography in children with minor head injury. CMAJ. 2010;182(4):341-348. doi:10.1503/cmaj.091423
}
\examples{

# Example 1: High Risk
# GCS 14 at 2h (+1), Irritable (+1)
catch_head_injury_rule(1, 0, 0, 1, 0, 0, 0)

# Example 2: Medium Risk
# Normal GCS, but Dangerous Mechanism (Fall >3ft)
catch_head_injury_rule(0, 0, 0, 0, 0, 0, 1)

# Example 3: Low Risk
# No risk factors
catch_head_injury_rule(0, 0, 0, 0, 0, 0, 0)
}
