\name{cytokine_release_syndrome_grading}
\alias{cytokine_release_syndrome_grading}
\title{
Cytokine Release Syndrome (CRS) Grading (ASTCT 2019)
}
\description{
Calculates the grade of Cytokine Release Syndrome (CRS) according to the 2019 American Society for Transplantation and Cellular Therapy (ASTCT) consensus grading system. This system is used to assess the severity of CRS in patients receiving immune effector cell therapies (e.g., CAR-T cells).
}
\usage{
cytokine_release_syndrome_grading(temperature_c, hypotension_present,
                                  hypotension_management, hypoxia_present,
                                  hypoxia_management)
}
\arguments{
  \item{temperature_c}{
Numeric. Patient temperature in degrees Celsius. Fever (>= 38.0 C) is a prerequisite for CRS diagnosis.
}
  \item{hypotension_present}{
Numeric (0 or 1). Presence of hypotension. (1 = Yes).
}
  \item{hypotension_management}{
String. Management required for hypotension. Options: "none", "fluids", "low_dose_vasopressor" (e.g., one pressor), "high_dose_vasopressor" (e.g., multiple pressors).
}
  \item{hypoxia_present}{
Numeric (0 or 1). Presence of hypoxia (SpO2 < 93\% on room air). (1 = Yes).
}
  \item{hypoxia_management}{
String. Management required for hypoxia. Options: "none", "low_flow_o2" (<6L/min NC), "high_flow_o2" (>=6L/min NC, mask), "positive_pressure" (CPAP, BiPAP, Mechanical Ventilation).
}
}
\value{
A list containing:
\item{CRS_Grade}{The calculated CRS Grade (0-4).}
\item{Description}{The clinical definition of the assigned grade.}
}
\references{
Lee DW, Santomasso BD, Locke FL, et al. ASTCT Consensus Grading for Cytokine Release Syndrome and Neurologic Toxicity Associated with Immune Effector Cells. Biol Blood Marrow Transplant. 2019;25(4):625-638. doi:10.1016/j.bbmt.2018.12.758
}
\examples{

# Example 1: Grade 2 CRS
# Fever 38.5, Hypotension responding to fluids, No hypoxia
cytokine_release_syndrome_grading(38.5, 1, "fluids", 0, "none")

# Example 2: Grade 3 CRS
# Fever 39.0, Hypotension on Norepi, Hypoxia on High Flow O2
cytokine_release_syndrome_grading(39.0, 1, "low_dose_vasopressor", 1, "high_flow_o2")
}
