\name{maddreys_discriminant_function}
\alias{maddreys_discriminant_function}
\title{
Maddrey's Discriminant Function for Alcoholic Hepatitis
}
\description{
Calculates Maddrey's Discriminant Function (MDF) score to assess the severity and prognosis of alcoholic hepatitis. A score of 32 or higher identifies patients with a high risk of short-term mortality who may benefit from corticosteroid therapy.
}
\usage{
maddreys_discriminant_function(pt_patient_seconds, pt_control_seconds,
                               bilirubin, bilirubin_units = "mg/dL")
}
\arguments{
  \item{pt_patient_seconds}{
Numeric. Patient's Prothrombin Time in seconds.
}
  \item{pt_control_seconds}{
Numeric. Control Prothrombin Time in seconds (typically around 12-14 seconds).
}
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{bilirubin_units}{
String. Units for bilirubin input. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{Maddrey_DF_Score}{The calculated score.}
\item{Prognosis}{Interpretation of severity.}
\item{Mortality_Risk}{Estimated risk of short-term mortality.}
\item{Recommendation}{Guidance on treatment considerations (e.g., corticosteroids).}
}
\references{
Maddrey WC, Boitnott JK, Bedine MS, et al. Corticosteroid therapy of alcoholic hepatitis. Gastroenterology. 1978;75(2):193-199.
}
\examples{

# Example 1: Severe (Score >= 32)
# PT 22s (Control 12s), Bili 10 mg/dL
# Score = 4.6*(22-12) + 10 = 56
maddreys_discriminant_function(22, 12, 10)

# Example 2: Mild
# PT 14s (Control 12s), Bili 5 mg/dL
# Score = 4.6*(14-12) + 5 = 14.2
maddreys_discriminant_function(14, 12, 5)
}
