\name{meld_score_original}
\alias{meld_score_original}
\title{
Model for End-Stage Liver Disease (MELD) Score (Original, Pre-2016)
}
\description{
Calculates the original MELD score used to assess the severity of end-stage liver disease and predict 3-month mortality. This version uses Creatinine, Bilirubin, and INR. Note: The United Network for Organ Sharing (UNOS) updated their policy in 2016 to use the MELD-Na score for transplant prioritization.
}
\usage{
meld_score_original(bilirubin, inr, creatinine, on_dialysis = 0,
                    bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{on_dialysis}{
Numeric (0 or 1). Has the patient had dialysis at least twice in the past week? (1 = Yes). If Yes, creatinine is capped at 4.0 mg/dL.
}
  \item{bilirubin_units}{
String. Units for bilirubin input. Options: "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L".
}
}
\details{
The formula is:
\deqn{MELD = 10 \times (0.957 \times \ln(Creatinine) + 0.378 \times \ln(Bilirubin) + 1.120 \times \ln(INR) + 0.643)}
Any value less than 1.0 is set to 1.0. Creatinine is capped at 4.0 mg/dL.
}
\value{
A list containing:
\item{MELD_Score}{The calculated score (Range 6-40).}
\item{Est_3_Month_Mortality}{Estimated 3-month mortality percentage.}
}
\references{
Kamath PS, Wiesner RH, Malinchoc M, et al. A model to predict survival in patients with end-stage liver disease. Hepatology. 2001;33(2):464-470. doi:10.1053/jhep.2001.22172
}
\examples{

# Example 1: Low Risk
# Bili 1.0, INR 1.0, Cr 1.0
# Score = 6
meld_score_original(1.0, 1.0, 1.0)

# Example 2: High Risk
# Bili 5.0, INR 2.0, Cr 2.5
# Score = 26
meld_score_original(5.0, 2.0, 2.5)
}
