\name{pawss_score}
\alias{pawss_score}
\title{
Prediction of Alcohol Withdrawal Severity Scale (PAWSS)
}
\description{
Calculates the PAWSS score to screen hospitalized patients for the risk of developing complicated alcohol withdrawal syndrome (AWS), specifically seizures or delirium tremens. The scale consists of 10 items (Threshold criteria, Patient interview, and Clinical evidence), each worth 1 point.
}
\usage{
pawss_score(recent_alcohol_use, bal_gt_200, previous_withdrawal,
            previous_seizures, previous_dts, previous_rehab, blackouts,
            concurrent_downer_use, concurrent_other_substance_use,
            autonomic_hyperactivity)
}
\arguments{
  \item{recent_alcohol_use}{
Numeric (0 or 1). Has the patient consumed alcohol within the last 30 days OR was the patient intoxicated at presentation? (1 = Yes).
}
  \item{bal_gt_200}{
Numeric (0 or 1). Is the blood alcohol level (BAL) > 200 mg/dL? (1 = Yes).
}
  \item{previous_withdrawal}{
Numeric (0 or 1). Has the patient experienced prior episodes of alcohol withdrawal? (1 = Yes).
}
  \item{previous_seizures}{
Numeric (0 or 1). Has the patient experienced prior withdrawal seizures? (1 = Yes).
}
  \item{previous_dts}{
Numeric (0 or 1). Has the patient experienced prior delirium tremens (DTs)? (1 = Yes).
}
  \item{previous_rehab}{
Numeric (0 or 1). Has the patient undergone previous alcohol rehabilitation treatment? (1 = Yes).
}
  \item{blackouts}{
Numeric (0 or 1). Has the patient experienced blackouts? (1 = Yes).
}
  \item{concurrent_downer_use}{
Numeric (0 or 1). Has the patient combined alcohol with benzodiazepines or barbiturates in the last 90 days? (1 = Yes).
}
  \item{concurrent_other_substance_use}{
Numeric (0 or 1). Has the patient combined alcohol with any other substance of abuse in the last 90 days? (1 = Yes).
}
  \item{autonomic_hyperactivity}{
Numeric (0 or 1). Is there clinical evidence of increased autonomic activity (e.g., HR > 120 bpm, tremor, sweating, agitation, nausea)? (1 = Yes).
}
}
\value{
A list containing:
\item{PAWSS_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Classification (Low Risk < 4, High Risk >= 4).}
\item{Recommendation}{Clinical guidance regarding prophylaxis and monitoring.}
}
\references{
Maldonado JR, Sher Y, Ashouri JF, et al. The "Prediction of Alcohol Withdrawal Severity Scale" (PAWSS): systematic literature review and pilot study of a new scale for the prediction of complicated alcohol withdrawal syndrome. Alcohol. 2014;48(4):375-390. doi:10.1016/j.alcohol.2014.01.004
}
\examples{

# Example 1: High Risk (Score >= 4)
# Recent use, Hx of Seizures, Hx of DTs, Autonomic signs
pawss_score(1, 0, 1, 1, 1, 0, 0, 0, 0, 1)

# Example 2: Low Risk (Score < 4)
# Recent use, Hx of Rehab, Blackouts
pawss_score(1, 0, 0, 0, 0, 1, 1, 0, 0, 0)
}
