\name{rome_iv_child_cyclic_vomiting_syndrome}
\alias{rome_iv_child_cyclic_vomiting_syndrome}
\title{
Rome IV Diagnostic Criteria for Child Cyclic Vomiting Syndrome (CVS)
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Cyclic Vomiting Syndrome (CVS)** in children and adolescents. Diagnosis requires recurrent, stereotypical episodes of vomiting with acute onset and return to baseline health between episodes, excluding organic causes.
}
\usage{
rome_iv_child_cyclic_vomiting_syndrome(stereotypical_episodes, episode_count_6mo,
                                       inter_episodic_wellness,
                                       not_explained_by_other_condition,
                                       symptom_onset_ge_6_months,
                                       symptoms_active_last_3_months)
}
\arguments{
  \item{stereotypical_episodes}{
Numeric (0 or 1). Are episodes **stereotypical** in onset, duration (< 1 week), and frequency? (1 = Yes).
}
  \item{episode_count_6mo}{
Numeric. Number of discrete episodes in the **past 6 months**. (Must be >= 2).
}
  \item{inter_episodic_wellness}{
Numeric (0 or 1). Is there an **absence of vomiting** between episodes, with return to baseline health? (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Have other causes (e.g., GI, neurological, metabolic) been **excluded**? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have criteria been fulfilled for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Cyclic Vomiting Syndrome (CVS)" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Stereotypical (1), 3 episodes in 6 months,
#Inter-episodic wellness (1), Excluded other causes, Chronic duration met
rome_iv_child_cyclic_vomiting_syndrome(1, 3, 1, 1, 1, 1)

# Example 2: Not Met (Vomiting between episodes)
# Stereotypical (1), 2+ episodes, Vomiting between episodes
#(0 for inter_episodic_wellness)
rome_iv_child_cyclic_vomiting_syndrome(1, 4, 0, 1, 1, 1)
}
