\name{rsbi_score}
\alias{rsbi_score}
\title{
Rapid Shallow Breathing Index (RSBI)
}
\description{
Calculates the Rapid Shallow Breathing Index (RSBI), a prognostic tool used to predict the success of weaning a patient from mechanical ventilation. It is defined as the ratio of respiratory frequency to tidal volume (f/Vt). Scores less than 105 breaths/min/L suggest a high likelihood of successful extubation.
}
\usage{
rsbi_score(respiratory_rate, tidal_volume, volume_units = "L")
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory frequency in breaths per minute.
}
  \item{tidal_volume}{
Numeric. Tidal volume measured during spontaneous breathing.
}
  \item{volume_units}{
String. Units for tidal volume. Options: "L" (default) or "mL".
}
}
\value{
A list containing:
\item{RSBI_Score}{The calculated index value (breaths/min/L).}
\item{Interpretation}{Prognostic guidance based on the 105 threshold.}
}
\references{
Yang KL, Tobin MJ. A prospective study of indexes predicting the outcome of trials of weaning from mechanical ventilation. N Engl J Med. 1991;324(21):1445-1450. doi:10.1056/NEJM199105233242101
}
\examples{

# Example 1: Success Likely
# RR 20, Vt 0.4 L (400 mL)
# RSBI = 20 / 0.4 = 50
rsbi_score(20, 0.4)

# Example 2: Failure Likely
# RR 35, Vt 300 mL (0.3 L)
# RSBI = 35 / 0.3 = 116.7
rsbi_score(35, 300, "mL")
}
