% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_stan_data_full}
\alias{prepare_stan_data_full}
\title{Prepare data for full Stan model with link parameter inference}
\usage{
prepare_stan_data_full(
  formula,
  data,
  link = "logit",
  link_param = NULL,
  prior_beta_sd = 2.5,
  prior_c_sd = 10,
  link_prior = NULL
)
}
\arguments{
\item{formula}{A formula specifying the model}

\item{data}{A data frame containing the variables}

\item{link}{Link function name}

\item{link_param}{A list of link parameters. Values can be:
\itemize{
\item numeric: Use as fixed value
\item "estimate": Estimate the parameter with default prior
}}

\item{prior_beta_sd}{Prior SD for regression coefficients (default: 2.5)}

\item{prior_c_sd}{Prior SD for cutpoints (default: 10)}

\item{link_prior}{A list of custom prior specifications for link parameters}
}
\value{
A list suitable for passing to CmdStan (clm_full.stan)
}
\description{
Prepare data for full Stan model with link parameter inference
}
\keyword{internal}
