% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-qcoder.R
\name{RemoveCodings}
\alias{RemoveCodings}
\title{Remove codings of a QDA project}
\usage{
RemoveCodings(project, codings_id)
}
\arguments{
\item{project}{A QDA project (as created by the qcoder package)}

\item{codings_id}{A vector of integer corresponding with the id of the codings to remove}
}
\value{
A QDA project
}
\description{
Remove codings of a QDA project
}
\details{
This function removes one or many codings of a Qualitative Data Analysis (QDA) project. The codings are listed using the 'id' of codings.
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

my.cleansed.project <- RemoveCodings(my.project, 1)
}
