% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-constants.R
\docType{data}
\name{COGRAPH_SCALE}
\alias{COGRAPH_SCALE}
\title{cograph Scaling Constants}
\format{
A list with the following elements:
\describe{
\item{node_factor}{Scale factor applied to node_size parameter}
\item{node_default}{Default node size when not specified}
\item{label_default}{Default label size (cex multiplier)}
\item{label_coupled}{Whether label size is coupled to node size}
\item{edge_base}{Base edge width}
\item{edge_scale}{Edge width scale factor}
\item{edge_default}{Default edge width}
\item{arrow_factor}{Scale factor for arrow sizes}
\item{arrow_default}{Default arrow size}
}
}
\usage{
COGRAPH_SCALE
}
\description{
Central location for all scaling factors used in splot() and soplot().
These constants are calibrated to produce similar visual output to qgraph
when using equivalent parameter values.
}
\details{
The default scaling mode uses values calibrated to match qgraph visual appearance:
\itemize{
\item \code{node_size = 6} in cograph should look similar to \code{vsize = 6} in qgraph
\item \code{label_size = 1} uses cex-style multiplier (independent of node size)
\item \code{arrow_size = 1} produces consistent arrows between splot and soplot
}

Legacy mode preserves the original cograph v1.x behavior where:
\itemize{
\item Node sizes used a 0.04 scale factor
\item Label sizes were coupled to node size (vsize * 8)
\item Arrow sizes differed between splot (0.03) and soplot (0.015)
}
}
\keyword{internal}
