% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-layout.R
\name{CographLayout}
\alias{CographLayout}
\title{CographLayout R6 Class}
\description{
Class for managing layout algorithms and computing node positions.
}
\examples{
# Create a circular layout
layout <- CographLayout$new("circle")

# Apply to network
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- CographNetwork$new(adj)
coords <- layout$compute(net)
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CographLayout-new}{\code{CographLayout$new()}}
\item \href{#method-CographLayout-compute}{\code{CographLayout$compute()}}
\item \href{#method-CographLayout-normalize_coords}{\code{CographLayout$normalize_coords()}}
\item \href{#method-CographLayout-get_type}{\code{CographLayout$get_type()}}
\item \href{#method-CographLayout-get_params}{\code{CographLayout$get_params()}}
\item \href{#method-CographLayout-print}{\code{CographLayout$print()}}
\item \href{#method-CographLayout-clone}{\code{CographLayout$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-new"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-new}{}}}
\subsection{Method \code{new()}}{
Create a new CographLayout object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$new(type = "circle", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Layout type (e.g., "circle", "spring", "groups").}

\item{\code{...}}{Additional parameters for the layout algorithm.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new CographLayout object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-compute"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-compute}{}}}
\subsection{Method \code{compute()}}{
Compute layout coordinates for a network.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$compute(network, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network}}{A CographNetwork object.}

\item{\code{...}}{Additional parameters passed to the layout function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with x, y coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-normalize_coords"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-normalize_coords}{}}}
\subsection{Method \code{normalize_coords()}}{
Normalize coordinates to 0-1 range with padding.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$normalize_coords(coords, padding = 0.1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coords}}{Matrix or data frame with x, y columns.}

\item{\code{padding}}{Numeric. Padding around edges (default 0.1).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Normalized coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-get_type"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-get_type}{}}}
\subsection{Method \code{get_type()}}{
Get layout type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$get_type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-get_params}{}}}
\subsection{Method \code{get_params()}}{
Get layout parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$get_params()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-print"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-print}{}}}
\subsection{Method \code{print()}}{
Print layout summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographLayout-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CographLayout-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographLayout$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
