% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-network.R
\name{CographNetwork}
\alias{CographNetwork}
\title{CographNetwork R6 Class}
\description{
Core class representing a network for visualization. Stores nodes, edges,
layout coordinates, and aesthetic mappings.
}
\examples{
# Create network from adjacency matrix
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- CographNetwork$new(adj)

# Access properties
net$n_nodes
net$n_edges
net$is_directed
}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n_nodes}}{Number of nodes in the network.}

\item{\code{n_edges}}{Number of edges in the network.}

\item{\code{is_directed}}{Whether the network is directed.}

\item{\code{has_weights}}{Whether edges have weights.}

\item{\code{node_labels}}{Vector of node labels.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CographNetwork-new}{\code{CographNetwork$new()}}
\item \href{#method-CographNetwork-clone_network}{\code{CographNetwork$clone_network()}}
\item \href{#method-CographNetwork-set_nodes}{\code{CographNetwork$set_nodes()}}
\item \href{#method-CographNetwork-set_edges}{\code{CographNetwork$set_edges()}}
\item \href{#method-CographNetwork-set_directed}{\code{CographNetwork$set_directed()}}
\item \href{#method-CographNetwork-set_weights}{\code{CographNetwork$set_weights()}}
\item \href{#method-CographNetwork-set_layout_coords}{\code{CographNetwork$set_layout_coords()}}
\item \href{#method-CographNetwork-set_node_aes}{\code{CographNetwork$set_node_aes()}}
\item \href{#method-CographNetwork-set_edge_aes}{\code{CographNetwork$set_edge_aes()}}
\item \href{#method-CographNetwork-set_theme}{\code{CographNetwork$set_theme()}}
\item \href{#method-CographNetwork-get_nodes}{\code{CographNetwork$get_nodes()}}
\item \href{#method-CographNetwork-get_edges}{\code{CographNetwork$get_edges()}}
\item \href{#method-CographNetwork-get_layout}{\code{CographNetwork$get_layout()}}
\item \href{#method-CographNetwork-get_node_aes}{\code{CographNetwork$get_node_aes()}}
\item \href{#method-CographNetwork-get_edge_aes}{\code{CographNetwork$get_edge_aes()}}
\item \href{#method-CographNetwork-get_theme}{\code{CographNetwork$get_theme()}}
\item \href{#method-CographNetwork-set_layout_info}{\code{CographNetwork$set_layout_info()}}
\item \href{#method-CographNetwork-get_layout_info}{\code{CographNetwork$get_layout_info()}}
\item \href{#method-CographNetwork-set_plot_params}{\code{CographNetwork$set_plot_params()}}
\item \href{#method-CographNetwork-get_plot_params}{\code{CographNetwork$get_plot_params()}}
\item \href{#method-CographNetwork-print}{\code{CographNetwork$print()}}
\item \href{#method-CographNetwork-clone}{\code{CographNetwork$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-new"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-new}{}}}
\subsection{Method \code{new()}}{
Create a new CographNetwork object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$new(input = NULL, directed = NULL, node_labels = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Network input (matrix, edge list, or igraph object).}

\item{\code{directed}}{Logical. Force directed interpretation. NULL for auto-detect.}

\item{\code{node_labels}}{Character vector of node labels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new CographNetwork object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-clone_network"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-clone_network}{}}}
\subsection{Method \code{clone_network()}}{
Clone the network with optional modifications.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$clone_network()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new CographNetwork object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_nodes}{}}}
\subsection{Method \code{set_nodes()}}{
Set nodes data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_nodes(nodes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nodes}}{Data frame with node information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_edges"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_edges}{}}}
\subsection{Method \code{set_edges()}}{
Set edges data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_edges(edges)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{edges}}{Data frame with edge information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_directed"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_directed}{}}}
\subsection{Method \code{set_directed()}}{
Set directed flag.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_directed(directed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{directed}}{Logical.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_weights"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_weights}{}}}
\subsection{Method \code{set_weights()}}{
Set edge weights.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_weights(weights)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weights}}{Numeric vector of weights.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_layout_coords"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_layout_coords}{}}}
\subsection{Method \code{set_layout_coords()}}{
Set layout coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_layout_coords(coords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coords}}{Matrix or data frame with x, y columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_node_aes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_node_aes}{}}}
\subsection{Method \code{set_node_aes()}}{
Set node aesthetics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_node_aes(aes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aes}}{List of aesthetic parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_edge_aes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_edge_aes}{}}}
\subsection{Method \code{set_edge_aes()}}{
Set edge aesthetics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_edge_aes(aes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aes}}{List of aesthetic parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_theme"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_theme}{}}}
\subsection{Method \code{set_theme()}}{
Set theme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_theme(theme)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theme}}{CographTheme object or theme name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_nodes}{}}}
\subsection{Method \code{get_nodes()}}{
Get nodes data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_nodes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame with node information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_edges"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_edges}{}}}
\subsection{Method \code{get_edges()}}{
Get edges data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_edges()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame with edge information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_layout"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_layout}{}}}
\subsection{Method \code{get_layout()}}{
Get layout coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_layout()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame with x, y coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_node_aes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_node_aes}{}}}
\subsection{Method \code{get_node_aes()}}{
Get node aesthetics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_node_aes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of node aesthetic parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_edge_aes"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_edge_aes}{}}}
\subsection{Method \code{get_edge_aes()}}{
Get edge aesthetics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_edge_aes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of edge aesthetic parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_theme"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_theme}{}}}
\subsection{Method \code{get_theme()}}{
Get theme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_theme()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
CographTheme object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_layout_info"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_layout_info}{}}}
\subsection{Method \code{set_layout_info()}}{
Set layout info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_layout_info(info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{info}}{List with layout information (name, seed, etc.).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_layout_info"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_layout_info}{}}}
\subsection{Method \code{get_layout_info()}}{
Get layout info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_layout_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List with layout information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-set_plot_params"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-set_plot_params}{}}}
\subsection{Method \code{set_plot_params()}}{
Set plot parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$set_plot_params(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{List of all plot parameters used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-get_plot_params"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-get_plot_params}{}}}
\subsection{Method \code{get_plot_params()}}{
Get plot parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$get_plot_params()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of plot parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-print"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-print}{}}}
\subsection{Method \code{print()}}{
Print network summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographNetwork-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CographNetwork-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographNetwork$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
