% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-parse.R
\name{detect_duplicate_edges}
\alias{detect_duplicate_edges}
\title{Detect Duplicate Edges in Undirected Network}
\usage{
detect_duplicate_edges(edges)
}
\arguments{
\item{edges}{Data frame with \code{from} and \code{to} columns (and optionally
\code{weight}).}
}
\value{
A list with two components:
\describe{
\item{has_duplicates}{Logical indicating whether any duplicates were found.}
\item{info}{A list of duplicate details, where each element contains:
\code{nodes} (the node pair), \code{count} (number of edges), and
\code{weights} (vector of weights if available).}
}
}
\description{
Identifies edges that appear multiple times between the same pair of nodes.
For undirected networks, edges A\code{->}B and B\code{->}A are considered duplicates.
For directed networks, only identical from\code{->}to pairs are duplicates.
}
\details{
This function is useful for cleaning network data before visualization.
Duplicate edges can arise from:
\itemize{
\item Data collection errors (same edge recorded twice)
\item Combining multiple data sources
\item Converting from formats that allow multi-edges
\item Edge lists that include both A\code{->}B and B\code{->}A for undirected networks
}

The function creates canonical keys by sorting node pairs (lower index first),
so edges 1\code{->}2 and 2\code{->}1 map to the same key "1-2" in undirected mode.
}
\seealso{
\code{\link{aggregate_duplicate_edges}} for combining duplicates into
single edges
}
\keyword{internal}
