% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-deprecation.R
\name{handle_deprecated_param}
\alias{handle_deprecated_param}
\title{Handle Deprecated Parameter}
\usage{
handle_deprecated_param(
  new_val,
  old_val,
  new_name,
  old_name,
  new_val_was_set = NULL
)
}
\arguments{
\item{new_val}{The value of the new parameter name.}

\item{old_val}{The value of the old (deprecated) parameter name.}

\item{new_name}{Character string of the new parameter name (for warning message).}

\item{old_name}{Character string of the old parameter name (for warning message).}

\item{new_val_was_set}{Logical. TRUE if the user explicitly set new_val
(FALSE means it's just the default). When NULL, the function checks if new_val
is NULL to determine this.}
}
\value{
The effective parameter value.
}
\description{
Handles backwards compatibility for renamed parameters. If the old parameter
name is used (not NULL), issues a deprecation warning and returns the old value.
Otherwise returns the new parameter value.
}
\details{
For parameters with defaults, use \code{new_val_was_set} to indicate whether the
user explicitly provided the new value. If FALSE (user didn't set it) and
old_val is provided, the old value takes precedence.
}
\keyword{internal}
