% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-network.R
\name{is_directed}
\alias{is_directed}
\title{Check if Network is Directed}
\usage{
is_directed(x)
}
\arguments{
\item{x}{A cograph_network object.}
}
\value{
Logical: TRUE if directed, FALSE if undirected.
}
\description{
Checks whether a cograph_network is directed.
}
\examples{
# Symmetric matrix -> undirected
mat <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- as_cograph(mat)
is_directed(net)  # FALSE

# Asymmetric matrix -> directed
mat2 <- matrix(c(0, 1, 0, 0, 0, 1, 0, 0, 0), nrow = 3)
net2 <- as_cograph(mat2)
is_directed(net2)  # TRUE
}
\seealso{
\code{\link{as_cograph}}
}
\keyword{internal}
