% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-oval.R
\name{layout_oval}
\alias{layout_oval}
\title{Oval Layout}
\usage{
layout_oval(
  network,
  ratio = 1.5,
  order = NULL,
  start_angle = pi/2,
  clockwise = TRUE,
  rotation = 0
)
}
\arguments{
\item{network}{A CographNetwork object.}

\item{ratio}{Aspect ratio (width/height). Values > 1 create horizontal ovals,
values < 1 create vertical ovals. Default 1.5.}

\item{order}{Optional vector specifying node order (indices or labels).}

\item{start_angle}{Starting angle in radians (default: pi/2 for top).}

\item{clockwise}{Logical. Arrange nodes clockwise? Default TRUE.}

\item{rotation}{Rotation angle in radians to tilt the entire oval. Default 0.}
}
\value{
Data frame with x, y coordinates.
}
\description{
Arrange nodes evenly spaced around an ellipse. This creates an oval-shaped
network layout that is wider than it is tall (or vice versa depending on ratio).
}
\examples{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- CographNetwork$new(adj)
coords <- layout_oval(net, ratio = 1.5)
}
