% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-spring.R
\name{layout_spring}
\alias{layout_spring}
\title{Fruchterman-Reingold Spring Layout}
\usage{
layout_spring(
  network,
  iterations = 500,
  cooling = 0.95,
  repulsion = 1,
  attraction = 1,
  seed = NULL,
  initial = NULL
)
}
\arguments{
\item{network}{A CographNetwork object.}

\item{iterations}{Number of iterations (default: 500).}

\item{cooling}{Rate of temperature decrease (default: 0.95).}

\item{repulsion}{Repulsion constant (default: 1).}

\item{attraction}{Attraction constant (default: 1).}

\item{seed}{Random seed for reproducibility.}

\item{initial}{Optional initial coordinates (matrix or data frame).}
}
\value{
Data frame with x, y coordinates.
}
\description{
Compute node positions using the Fruchterman-Reingold force-directed
algorithm. Nodes connected by edges are attracted to each other while
all nodes repel each other.
}
\examples{
adj <- matrix(c(0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0), nrow = 4)
net <- CographNetwork$new(adj)
coords <- layout_spring(net, seed = 42)
}
