% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes-edges.R
\name{sn_edges}
\alias{sn_edges}
\title{Set Edge Aesthetics}
\usage{
sn_edges(
  network,
  width = NULL,
  edge_size = NULL,
  esize = NULL,
  edge_width_range = NULL,
  edge_scale_mode = NULL,
  edge_cutoff = NULL,
  cut = NULL,
  color = NULL,
  edge_positive_color = NULL,
  positive_color = NULL,
  edge_negative_color = NULL,
  negative_color = NULL,
  alpha = NULL,
  style = NULL,
  curvature = NULL,
  arrow_size = NULL,
  show_arrows = NULL,
  maximum = NULL,
  width_scale = NULL,
  labels = NULL,
  label_size = NULL,
  label_color = NULL,
  label_position = NULL,
  label_offset = NULL,
  label_bg = NULL,
  label_bg_padding = NULL,
  label_fontface = NULL,
  label_border = NULL,
  label_border_color = NULL,
  label_underline = NULL,
  label_shadow = NULL,
  label_shadow_color = NULL,
  label_shadow_offset = NULL,
  label_shadow_alpha = NULL,
  bidirectional = NULL,
  loop_rotation = NULL,
  curve_shape = NULL,
  curve_pivot = NULL,
  curves = NULL,
  ci = NULL,
  ci_scale = NULL,
  ci_alpha = NULL,
  ci_color = NULL,
  ci_style = NULL,
  ci_arrows = NULL,
  ci_lower = NULL,
  ci_upper = NULL,
  label_style = NULL,
  label_template = NULL,
  label_digits = NULL,
  label_ci_format = NULL,
  label_p = NULL,
  label_p_digits = NULL,
  label_p_prefix = NULL,
  label_stars = NULL
)
}
\arguments{
\item{network}{A cograph_network object, matrix, data.frame, or igraph object.
Matrices and other inputs are auto-converted.}

\item{width}{Edge width. Can be a single value, vector (per-edge), or "weight".}

\item{edge_size}{Base edge size for weight scaling. NULL (default) uses adaptive sizing
based on network size: \code{15 * exp(-n_nodes/90) + 1}. Larger values = thicker edges.}

\item{esize}{Deprecated. Use \code{edge_size} instead.}

\item{edge_width_range}{Output width range as c(min, max) for weight-based scaling.
Default c(0.5, 4). Edges are scaled to fit within this range.}

\item{edge_scale_mode}{Scaling mode for edge weights: "linear" (default),
"log" (for wide weight ranges), "sqrt" (moderate compression),
or "rank" (equal visual spacing).}

\item{edge_cutoff}{Two-tier cutoff for edge width scaling. NULL (default) = auto 75th percentile.
0 = disabled. Positive number = manual threshold.}

\item{cut}{Deprecated. Use \code{edge_cutoff} instead.}

\item{color}{Edge color. Can be a single color, vector, or "weight" for
automatic coloring based on edge weights.}

\item{edge_positive_color}{Color for positive edge weights.}

\item{positive_color}{Deprecated. Use \code{edge_positive_color} instead.}

\item{edge_negative_color}{Color for negative edge weights.}

\item{negative_color}{Deprecated. Use \code{edge_negative_color} instead.}

\item{alpha}{Edge transparency (0-1).}

\item{style}{Line style: "solid", "dashed", "dotted", "longdash", "twodash".}

\item{curvature}{Edge curvature amount (0 = straight).}

\item{arrow_size}{Size of arrow heads for directed networks.}

\item{show_arrows}{Logical. Show arrows? Default TRUE for directed networks.}

\item{maximum}{Maximum edge weight for scaling width. Weights above this are
capped. Similar to qgraph's maximum parameter.}

\item{width_scale}{Scale factor for edge widths. Values > 1 make edges thicker,
values < 1 make them thinner. Applied after all other width calculations.}

\item{labels}{Edge labels. Can be TRUE (show weights), a vector, or column name.}

\item{label_size}{Edge label text size.}

\item{label_color}{Edge label text color.}

\item{label_position}{Position along edge (0 = source, 0.5 = middle, 1 = target).}

\item{label_offset}{Perpendicular offset from edge line.}

\item{label_bg}{Background color for edge labels (default "white"). Set to NA for transparent.}

\item{label_bg_padding}{Padding around label text as proportion of text size (default 0.3).}

\item{label_fontface}{Font face: "plain", "bold", "italic", "bold.italic" (default "plain").}

\item{label_border}{Border style: NULL (none), "rect", "rounded", "circle" (default NULL).}

\item{label_border_color}{Border color for label border (default "gray50").}

\item{label_underline}{Logical. Underline the label text? (default FALSE).}

\item{label_shadow}{Logical. Enable drop shadow for labels? (default FALSE).}

\item{label_shadow_color}{Color for label shadow (default "gray40").}

\item{label_shadow_offset}{Offset distance for shadow in points (default 0.5).}

\item{label_shadow_alpha}{Transparency for shadow (0-1, default 0.5).}

\item{bidirectional}{Logical. Show arrows at both ends of edges?}

\item{loop_rotation}{Angle in radians for self-loop direction (default: pi/2 = top).}

\item{curve_shape}{Spline tension for curved edges (-1 to 1, default: 0).}

\item{curve_pivot}{Pivot position along edge for curve control point (0-1, default: 0.5).}

\item{curves}{Curve mode: FALSE (straight edges), "mutual" (only curve reciprocal pairs),
or "force" (curve all edges). Default FALSE.}

\item{ci}{Numeric vector of CI widths (0-1 scale). Larger values = more uncertainty.}

\item{ci_scale}{Width multiplier for CI underlay thickness. Default 2.}

\item{ci_alpha}{Transparency for CI underlay (0-1). Default 0.15.}

\item{ci_color}{CI underlay color. NA (default) uses main edge color.}

\item{ci_style}{Line type for CI underlay: 1=solid, 2=dashed, 3=dotted. Default 2.}

\item{ci_arrows}{Logical: show arrows on CI underlay? Default FALSE.}

\item{ci_lower}{Numeric vector of lower CI bounds for labels.}

\item{ci_upper}{Numeric vector of upper CI bounds for labels.}

\item{label_style}{Preset style: "none", "estimate", "full", "range", "stars".}

\item{label_template}{Template with placeholders: \{est\}, \{range\}, \{low\}, \{up\}, \{p\}, \{stars\}.}

\item{label_digits}{Decimal places for estimates in template. Default 2.}

\item{label_ci_format}{CI format: "bracket" for \verb{[low, up]} or "dash" for \code{low-up}.}

\item{label_p}{Numeric vector of p-values for edges.}

\item{label_p_digits}{Decimal places for p-values. Default 3.}

\item{label_p_prefix}{Prefix for p-values. Default "p=".}

\item{label_stars}{Stars for labels: character vector, TRUE (compute from p),
or numeric (treated as p-values).}
}
\value{
Modified cograph_network object that can be piped to further customization
functions or plotting functions.
}
\description{
Customize the visual appearance of edges in a network plot.
}
\details{
\subsection{Vectorization}{

Most aesthetic parameters can be specified as:
\itemize{
\item \strong{Single value}: Applied to all edges
\item \strong{Vector}: Per-edge values (must match edge count)
\item \strong{"weight"}: Special value for \code{width} and \code{color} that
auto-maps from edge weights
}
}

\subsection{Weight-Based Styling}{

When \code{color = "weight"}, edges are colored by sign:
\itemize{
\item Positive weights use \code{edge_positive_color} (default: green)
\item Negative weights use \code{edge_negative_color} (default: red)
}

When \code{width = "weight"}, edge widths scale with absolute weight values,
respecting the \code{maximum} parameter if set.
}

\subsection{Edge Label Templates}{

For statistical output (e.g., regression coefficients with CIs), use templates:
\itemize{
\item \code{label_template = "\{est\}"}: Show estimate only
\item \code{label_template = "\{est\} [\{low\}, \{up\}]"}: Estimate with CI
\item \code{label_template = "\{est\}\{stars\}"}: Estimate with significance
}

Preset styles via \code{label_style}:
\itemize{
\item \code{"estimate"}: Weight/estimate only
\item \code{"full"}: Estimate + CI in brackets
\item \code{"range"}: CI range only
\item \code{"stars"}: Significance stars
}
}

\subsection{CI Underlays}{

Visualize uncertainty by drawing a wider, semi-transparent edge behind:
\itemize{
\item \code{ci}: Vector of CI widths (0-1 scale)
\item \code{ci_scale}: Width multiplier (default 2)
\item \code{ci_alpha}: Transparency (default 0.15)
}
}
}
\examples{
adj <- matrix(c(0, 1, -0.5, 1, 0, 1, -0.5, 1, 0), nrow = 3)

# Basic: auto-style by weight
cograph(adj) |>
  sn_edges(width = "weight", color = "weight")

# Direct matrix input (auto-converted)
adj |> sn_edges(width = 2, color = "gray50")

# Custom positive/negative colors
cograph(adj) |>
  sn_edges(
    color = "weight",
    edge_positive_color = "darkblue",
    edge_negative_color = "darkred"
  ) |>
  splot()

# Edge labels showing weights
cograph(adj) |>
  sn_edges(labels = TRUE, label_size = 0.8) |>
  splot()

# Statistical output with CI template
# Suppose we have estimates, lower/upper CI bounds
estimates <- c(0.5, -0.3, 0.8)
ci_lo <- c(0.2, -0.6, 0.5)
ci_hi <- c(0.8, -0.1, 1.1)

cograph(adj) |>
  sn_edges(
    label_template = "{est} [{low}, {up}]",
    ci_lower = ci_lo,
    ci_upper = ci_hi,
    label_digits = 2
  ) |>
  splot()

# Curved edges for reciprocal pairs
cograph(adj) |>
  sn_edges(curves = "mutual", curvature = 0.3) |>
  splot()
}
\seealso{
\code{\link{sn_nodes}} for node customization,
\code{\link{cograph}} for network creation,
\code{\link{splot}} and \code{\link{soplot}} for plotting,
\code{\link{sn_layout}} for layout algorithms,
\code{\link{sn_theme}} for visual themes
}
