% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cograph.R
\name{sn_palette}
\alias{sn_palette}
\title{Apply Color Palette to Network}
\usage{
sn_palette(network, palette, target = "nodes", by = NULL)
}
\arguments{
\item{network}{A cograph_network object, matrix, data.frame, or igraph object.
Matrices and other inputs are auto-converted.}

\item{palette}{Palette name or function.}

\item{target}{What to apply the palette to: "nodes", "edges", or "both".}

\item{by}{Variable to map colors to (for nodes: column name or "group").}
}
\value{
Modified cograph_network object.
}
\description{
Apply a color palette for node and/or edge coloring.
}
\details{
\subsection{Available Palettes}{

Use \code{list_palettes()} to see all available palettes. Common options:
\describe{
\item{\strong{viridis}}{Perceptually uniform, colorblind-friendly.}
\item{\strong{colorblind}}{Optimized for color vision deficiency.}
\item{\strong{pastel}}{Soft, muted colors.}
\item{\strong{bright}}{Saturated, vivid colors.}
\item{\strong{grayscale}}{Shades of gray.}
}

You can also pass a custom palette function that takes \code{n} and returns
\code{n} colors.
}
}
\examples{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)

# Apply palette to nodes
cograph(adj) |> sn_palette("viridis") |> splot()

# Apply to edges
cograph(adj) |> sn_palette("colorblind", target = "edges") |> splot()

# Apply to both
cograph(adj) |> sn_palette("pastel", target = "both") |> splot()

# Custom palette function
my_pal <- function(n) rainbow(n, s = 0.7)
cograph(adj) |> sn_palette(my_pal) |> splot()

# Direct matrix input
adj |> sn_palette("viridis")
}
\seealso{
\code{\link{cograph}} for network creation,
\code{\link{sn_theme}} for visual themes,
\code{\link{sn_nodes}} for node customization,
\code{\link{list_palettes}} to see available palettes,
\code{\link{splot}} and \code{\link{soplot}} for plotting
}
