% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_numeric_variables.R
\name{identify_numeric_variables}
\alias{identify_numeric_variables}
\title{Find valid numeric variables in a dataframe}
\usage{
identify_numeric_variables(
  df = NULL,
  responses = NULL,
  predictors = NULL,
  decimals = 4,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{predictors}{(required, character vector) Names of the predictors to identify. Default: NULL}

\item{decimals}{(required, integer) Number of decimal places for the zero variance test. Smaller numbers will increase the number of variables detected as near-zero variance. Recommended values will depend on the range of the numeric variables in 'df'. Default: 4}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
list:
\itemize{
\item \code{valid}: character vector with valid numeric predictor names.
\item \code{invalid}: character vector with invalid numeric predictor names due to near-zero variance.
}
}
\description{
Identifies valid numeric variables and ignores those with constant values.
}
\examples{

data(vi_smol, vi_predictors)

x <- identify_numeric_variables(
  df = vi_smol,
  responses = "vi_numeric",
  predictors = vi_predictors
)

#valid numeric predictors
x$valid

#invalid due to zero variance (none here)
x$invalid

}
\seealso{
Other data_types: 
\code{\link{identify_categorical_variables}()},
\code{\link{identify_logical_variables}()},
\code{\link{identify_response_type}()},
\code{\link{identify_valid_variables}()},
\code{\link{identify_zero_variance_variables}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
