% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{polydivdif}
\alias{polydivdif}
\title{Approximating polynomial for divided differences}
\usage{
polydivdif(x0, x, f, np = length(x))
}
\arguments{
\item{x0}{A vector of real numbers. These are the grid points chosen for
the interpolation.}

\item{x}{A vector of real numbers. Grid points corresponding to the tabulated
(known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values of the function, 
corresponding to the grid \code{x}.}

\item{np}{An integer. The number of known points used for the
interpolation. np > 2 because the smallest and largest
value of \code{x} have to be always among the known
points. Aside from the points at the extremes of the
interpolation interval, the other points are chosen
randomly.}
}
\value{
A named list of length 3 and names \code{x}, \code{f} and \code{f0}. 
\describe{
   \item{\code{x}}{Tabulated grid points used for the interpolation.}
   \item{\code{f}}{Tabulated function points used for the interpolation. They 
                   correspond to \code{x}.}
   \item{\code{f0}}{Interpolated values. They correspond to the input vector
                    \code{x0}.}
}
}
\description{
Calculation of a polynomial of order n via divided differences. All n tabulated
points provided (with n greater or equal than 2) are used by default for the 
calculation, but the option is available to use only np points, where np must be 
greater or equal than 2. In case only part of the n available tabulated points is
used (np < n), the first two points are fixed to be equal to the smallest and largest
tabulated grid x points; the remaining np-2 points are selected randomly among the 
n-2 remaining ones.
}
\examples{
# Tabulated grid points for function sin(x)
x <- seq(0,3*pi/2,length=20)
f <- sin(x)

# Grid of interpolated points
x0 <- seq(0,3*pi/2,length=200)

# Interpolation using all 20 tabulated points
ltmp <- polydivdif(x0,x,f)
plot(ltmp$x,ltmp$f,pch=16)
points(x0,ltmp$f0,type="l")

# Interpolation using only five points (dangerous!)
ltmp <- polydivdif(x0,x,f,np=5)
points(ltmp$x,ltmp$f,col=2,cex=1.5)
points(x0,ltmp$f0,type="l",col=2)

}
