% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{penalty_elastic_net}
\alias{penalty_elastic_net}
\title{Elastic net penalty (combination of L1 and L2)}
\usage{
penalty_elastic_net(alpha = 0.5, weights = NULL)
}
\arguments{
\item{alpha}{Balance between L1 and L2 (numeric in [0,1], default: 0.5)}

\item{weights}{Optional parameter weights (default: all 1)}
}
\value{
Penalty function
}
\description{
Creates a penalty combining L1 and L2 norms. The parameter alpha controls
the balance: alpha=1 is pure LASSO, alpha=0 is pure Ridge.
}
\examples{
# Equal mix of L1 and L2
penalty <- penalty_elastic_net(alpha = 0.5)

# More L1 (more sparsity)
penalty <- penalty_elastic_net(alpha = 0.9)

# More L2 (more shrinkage)
penalty <- penalty_elastic_net(alpha = 0.1)
}
