% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_survey.R
\name{download_survey}
\alias{download_survey}
\title{Download a survey from its Zenodo repository}
\usage{
download_survey(
  survey,
  directory = tempdir(),
  verbose = TRUE,
  overwrite = FALSE,
  timeout = 3600,
  rate = purrr::rate_backoff(pause_base = 5, max_times = 4)
)
}
\arguments{
\item{survey}{A DOI of a survey, (see \code{\link[=list_surveys]{list_surveys()}}). If a HTML link is
given, the DOI will be isolated and used.}

\item{directory}{Directory of where to save survey files. Defaults to
\code{\link[=tempdir]{tempdir()}}, so files do not persist across R sessions. For persistent
caching, pass \code{\link[=contactsurveys_dir]{contactsurveys_dir()}}, which uses \code{\link[tools:userdir]{tools::R_user_dir()}}
and appends the survey URL/DOI basename as a subdirectory. E.g., if you
provide "10.5281/zenodo.1095664" in the \code{survey} argument, it will save
the surveys into a directory \code{zenodo.1095664} under
\code{contactsurveys_dir()}. You can also set an environment variable,
\code{CONTACTSURVEYS_HOME}, see \code{\link[=Sys.setenv]{Sys.setenv()}} or \link{Renviron} for more detail.}

\item{verbose}{Whether downloads should be echoed to output. Default TRUE.}

\item{overwrite}{If files should be overwritten if they already exist.
Default FALSE}

\item{timeout}{A numeric value specifying timeout in seconds. Default
3600 seconds.}

\item{rate}{a
\href{https://purrr.tidyverse.org/reference/rate-helpers.html}{purrr rate}
object, to facilitate downloading if the download fails. Defaults to an
exponential backoff of 5 seconds (up to 4 attempts: 1 initial + 3 retries)
changed by specifying your own rate object, see \code{?purrr::rate_backoff()}
for details.}
}
\value{
a vector of filenames, where the surveys were downloaded
}
\description{
Downloads survey data. Uses a caching mechanism via the default
argument for \code{directory}.
}
\examples{
\donttest{
list_surveys()
peru_survey <- download_survey("https://doi.org/10.5281/zenodo.1095664")
}
}
\seealso{
\code{\link[=list_surveys]{list_surveys()}}
}
