% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{row_norm1}
\alias{row_norm1}
\title{Normalize matrix rows to sum to one}
\usage{
row_norm1(M)
}
\arguments{
\item{M}{Numeric matrix to be row-normalized.}
}
\value{
Matrix of the same dimensions as \code{M} with each row summing to 1
(except rows that originally summed to zero).
}
\description{
Scales each row of a matrix so that its elements sum to 1. Handles zero-sum
rows by leaving them unchanged (avoiding division by zero).
}
\examples{
\donttest{
M <- matrix(c(1, 2, 3, 4, 5, 6), nrow = 2)
M_norm <- row_norm1(M)
rowSums(M_norm)  # Should be c(1, 1)
}

}
