% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chrr_measure_data.R
\name{get_chrr_measure_data}
\alias{get_chrr_measure_data}
\title{Retrieve County Health Rankings & Roadmaps measure data from 'Zenodo'}
\usage{
get_chrr_measure_data(
  geography = c("county", "state", "national"),
  measure,
  release_year = NULL,
  refresh = FALSE,
  citation = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{geography}{A string specifying the level of geography to return.
Options are:
\itemize{
\item \code{"county"} – returns all county-level estimates.
\item \code{"state"} – returns all state-level estimates (excluding national).
\item \code{"national"} – returns only national-level estimates (\code{state_fips == "00"}).
}}

\item{measure}{Either:
\itemize{
\item A numeric \code{measure_id} (e.g., \code{21}, \code{85}, etc.), or
\item A character string matching a \code{measure_name}
(case-insensitive).
}
Use the \code{list_chrr_measures()} function to print all available
\code{measure_id}s and \code{measure_name}s for a given release year.}

\item{release_year}{\code{Numeric}. Specifies the CHR&R release year to pull data.
Defaults to the most recent release year.}

\item{refresh}{\code{Logical}. If \code{TRUE}, forces re-download of data
even if a cached version is available. Defaults to \code{FALSE}.}

\item{citation}{\code{Logical}. If \code{TRUE} (default), prints the
appropriate Zenodo DOI for the requested release year which is useful for citation.
Set to \code{FALSE} to suppress DOI output.}

\item{verbose}{\code{Logical}. If \code{TRUE} (default), additional information about the
selected measure is displayed including the measure name and selected metadata fields.
Set to \code{FALSE} to return only the requested \code{data.frame}.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame})
containing CHR&R data for the specified measure, geography,
and release year.

The tibble contains one row per geographic unit and includes:
\describe{
\item{state_fips}{Character. Two-digit state FIPS code.}
\item{county_fips}{Character. Three-digit county FIPS code.
Present only for county-level data.}
\item{raw_value}{Numeric. Reported measure value.}
\item{numerator}{Numeric. Measure numerator, if available.}
\item{denominator}{Numeric. Measure denominator, if available.}
\item{ci_low}{Numeric. Lower confidence interval bound, if available.}
\item{ci_high}{Numeric. Upper confidence interval bound, if available.}
}

The returned tibble represents the full set of observations for
the requested measure at the specified geographic level and
release year.
}
\description{
Downloads and filters County Health Rankings & Roadmaps (CHR&R) data directly
from the 'Zenodo' archive
(\doi{10.5281/zenodo.18157681}).
Users provide the measure ID, geography type, and release year as inputs.
The function returns data for the specified measure across the specified geography
for the given release year. It mimics the style and behavior of
\code{tidycensus::get_decennial()}.
}
\examples{
\donttest{
# Get county-level data for measure 21 (high school graduation) in 2023
county_data <- get_chrr_measure_data(
                  geography = "county",
                  measure = 21,
                  release_year = 2023)

# Get state-level data for "Insufficient Sleep" in 2022
state_data <- get_chrr_measure_data(
                  geography = "state",
                  measure = "insufficient sleep",
                  release_year = 2022)

# Get national-level data for "Uninsured" in 2024
nat_data <- get_chrr_measure_data(
                  geography = "national",
                  measure = "uninsured",
                  release_year = 2024)
}

}
