% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debt.R
\name{debt_built_schedule}
\alias{debt_built_schedule}
\title{Debt schedule for bullet and amortising loans}
\usage{
debt_built_schedule(
  principal,
  rate_annual,
  maturity,
  type = c("amort", "bullet"),
  extra_amort_pct = 0,
  arrangement_fee_pct = 0
)
}
\arguments{
\item{principal}{Numeric scalar. Amount borrowed at \code{year = 0} (greater than or equal to 0).}

\item{rate_annual}{Numeric scalar in \code{[0, 1]}. Annual nominal interest rate.}

\item{maturity}{Integer scalar greater than or equal to 1. Duration in years; returned years are \code{0..maturity}.}

\item{type}{Character scalar. Either \code{"amort"} (constant payment) or \code{"bullet"}.}

\item{extra_amort_pct}{Numeric scalar in \code{[0, 1]}. Additional annual amortisation rate (used only for \code{"bullet"}).}

\item{arrangement_fee_pct}{Numeric scalar in \code{[0, 1]}. Arrangement fee rate applied to \code{principal}.}
}
\value{
A tibble with columns \code{year}, \code{debt_draw}, \code{interest}, \code{amortization},
\code{payment}, \code{arrangement_fee}, \code{outstanding_debt}, and \code{loan_init}.
}
\description{
Creates an annual schedule indexed from \code{0..maturity} with an initial
draw at \code{year = 0}, interest, amortisation, total payment, and end-of-year
outstanding balance. The convention is no payment at \code{year = 0}. For both
loan types, the outstanding principal is 0 at maturity up to rounding.
}
\examples{
sch_b <- debt_built_schedule(6e6, 0.045, maturity = 5, type = "bullet")
sch_a <- debt_built_schedule(6e6, 0.045, maturity = 5, type = "amort")
sch_b
sch_a

}
