% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_manifest}
\alias{styles_manifest}
\title{Compute the style-by-style manifest for canonical presets}
\usage{
styles_manifest(
  styles = c("core", "core_plus", "value_added", "opportunistic")
)
}
\arguments{
\item{styles}{Character vector of style names to include.
Defaults to the four canonical presets:
\code{c("core", "core_plus", "value_added", "opportunistic")}.}
}
\value{
A tibble with one row per style and the columns:
\code{style}, \code{class}, \code{irr_project}, \code{irr_equity},
\code{dscr_min_bul}, \code{ltv_init}, \code{ltv_max_fwd}, \code{npv_equity}.
}
\description{
This helper runs the four canonical style presets
(\code{"core"}, \code{"core_plus"}, \code{"value_added"}, \code{"opportunistic"})
through [\code{\link[=run_case]{run_case()}}] and extracts a compact set of indicators that are
salient for both investors and lenders:
}
\details{
\itemize{
\item project IRR (all-equity),
\item equity IRR (levered),
\item minimum DSCR under a bullet structure,
\item initial LTV at origination under a bullet structure,
\item maximum forward LTV under a bullet structure,
\item equity NPV.
}

The result is a tibble that can be reused both in vignettes and in automated
tests to ensure that the canonical presets preserve the intended
risk–return and leverage–coverage hierarchies.
}
