% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestEWOC-class}
\alias{NextBestEWOC-class}
\alias{.NextBestEWOC}
\alias{NextBestEWOC}
\alias{.DefaultNextBestEWOC}
\title{\code{NextBestEWOC}}
\usage{
NextBestEWOC(target, overdose, max_overdose_prob)

.DefaultNextBestEWOC()
}
\arguments{
\item{target}{(\code{proportion})\cr see slot definition.}

\item{overdose}{(\code{numeric})\cr see slot definition.}

\item{max_overdose_prob}{(\code{proportion})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestEWOC}} is the class implementing Escalation With Overdose Control
(EWOC). It recommends the highest possible dose subject to a probabilistic
constraint that the posterior probability of overdosing does not exceed
\code{max_overdose_prob}. Overdosing is defined as the model-based toxicity
probability lying inside the interval given by \code{overdose}.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{proportion})\cr target toxicity probability to be
achieved, below \code{overdose[1]}; only used for simulation reporting purposes.}

\item{\code{overdose}}{(\code{numeric})\cr the (exclusive) lower and (inclusive) upper boundaries of the
toxicity probability interval considered an overdose region. The prototype
uses \code{c(0.35, 1)} meaning probabilities > 0.35 are treated as overly toxic.}

\item{\code{max_overdose_prob}}{(\code{proportion})\cr maximum acceptable posterior
probability that the next recommended dose is in the overdose interval.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestEWOC()} function.
}
\examples{
# Example: Define EWOC next best dose rule.
# Target toxicity probability is 0.30. Overdose region is any probability > 0.35.
# We restrict posterior probability of recommending an overdosing dose to <= 0.25.
next_best_ewoc <- NextBestEWOC(
  target = 0.30,
  overdose = c(0.35, 1),
  max_overdose_prob = 0.25
)
}
\seealso{
\code{\link{NextBest}}, other next-best classes listed in its documentation.
}
