% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_time_period_system_levels}
\alias{cvd_time_period_system_levels}
\title{List available time periods and associated system levels}
\usage{
cvd_time_period_system_levels()
}
\value{
A tibble containing time periods and the corresponding system levels with the following columns:

A tibble with the following columns:
\describe{
\item{EndDate}{POSIXct. End date of the reporting period (e.g., "2023-12-31").}
\item{StartDate}{POSIXct. Start date of the reporting period. Typically set to a default baseline (e.g., "1900-01-01").}
\item{TimePeriodID}{Integer. Unique identifier for the time period.}
\item{TimePeriodName}{Character. Display label for the time period (e.g., "To December 2023", "Apr 2022 – Mar 2023").}
\item{IsVisible}{Logical or character. Indicates whether the time period is visible in the API or dashboard ("Y" or "N").}
\item{NationalLevel}{Logical or character. Indicates whether the data is available at the national level ("Y" or "N").}
\item{SystemLevelID}{Integer. Unique identifier for the system level (e.g., 1 = England, 4 = PCN).}
\item{SystemLevelName}{Character. Name of the system level (e.g., "England", "Region", "Sub-ICB", "PCN").}
}
If no data is found, returns a tibble describing the error.
}
\description{
Retrieves all available reporting periods from the CVDPREVENT API, along with the NHS system levels included in each time period.

This function is useful to determine which system levels (e.g., national, region, ICB, PCN, practice) have data available for each reporting period.
}
\details{
This function is helpful for understanding the data structure of each reporting period, especially if you need to filter or subset data by system level and time period in downstream API calls.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#*Proposed*-\%2FtimePeriod\%2FsystemLevels}{CVDPREVENT API documentation: Time period system levels} for technical details.
}

\examples{
\donttest{
# Retrieve all time periods and associated system levels
periods_levels <- cvd_time_period_system_levels()

# Show available system levels for the latest time period
periods_levels |>
  dplyr::slice_max(order_by = TimePeriodID) |>
  dplyr::select(TimePeriodID, TimePeriodName, SystemLevelID, SystemLevelName)
}

}
\seealso{
\code{\link[=cvd_time_period_list]{cvd_time_period_list()}}, \code{\link[=cvd_area_system_level_time_periods]{cvd_area_system_level_time_periods()}}
}
