% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{log_posterior_hyper}
\alias{log_posterior_hyper}
\alias{log_posterior_lower}
\title{Conditional Log-Posterior Distributions for MCMC Sampling}
\usage{
log_posterior_hyper(
  phi_j_mat,
  theta_j_mat,
  log_prior_hyper_fun,
  log_prior_lower_fun,
  temperatures,
  suppress_warnings = TRUE
)

log_posterior_lower(
  thetas_one_subj_mat,
  all_phis_mat,
  model_subj,
  log_prior_lower_funs,
  temperatures,
  suppress_warnings = TRUE
)
}
\arguments{
\item{phi_j_mat}{a numeric matrix of current group-level parameters
for one individual-level parameter. It must be 2 x n_chains and provide the
mean and standard deviation; in that order.}

\item{theta_j_mat}{a numeric matrix of individual-level parameter
values across all individuals and chains for one model parameter. Must
be n_chains x n_subj.}

\item{log_prior_hyper_fun}{a function that returns the log-prior density of
the hyperparameters. Must be a single function (not a list of functions) and
it must accept \code{phi_j_mat} as input.}

\item{log_prior_lower_fun}{a function that returns the log-prior density of
individual parameter values given the mean and standard deviation at the
group-level (as stored in \code{phi_j_mat}). Must be a single function
(not a list of functions) and it must accept \code{theta_j_mat} as a first
argument and input, and the mean and standard deviation with arguments
\code{mean} and \code{sd} (vectorized).}

\item{temperatures}{a numeric vector of temperature scaling values, one per
chain, used when applying tempered inference (e.g., in TIDE).}

\item{suppress_warnings}{logical, if TRUE, warnings created from
\code{log_prior_hyper_fun} and \code{log_prior_lower_fun(s)} are suppressed. The
default is true, because in the beginning of an MCMC sampler implausible
proposals are provided which can yield missing values and warnings.}

\item{thetas_one_subj_mat}{a named matrix of lower-level parameters for a
single participant. Each row represents one parameter, and each column one
chain.}

\item{all_phis_mat}{a named matrix of all current group-level parameters.
Each mean group-level parameter must be named \code{"M-<param>"} and each
standard deviation \code{"S-<param>"}. The \verb{<param>} part must match the
individual-level parameters in \code{thetas_one_subj_mat}. If this argument is
\code{NULL}, this indicates that the estimation is done in a non-hierarchical
fashion. Each row represents a hyper-parameter, and each column one
chain.}

\item{model_subj}{a \code{drift_dm} object, containing an individual's data.}

\item{log_prior_lower_funs}{a named list of functions, one per parameter
stored in \code{thetas_one_subj_mat}, returning the log-prior densities. It is
assumed that each function can take one type of parameter across chains
(i.e., a vector). In the non-hierarchical case, each function can only
accept a single vector (for the respective individual-level parameter across
chains). In the hierarchical case, each function must also support the
arguments \code{mean} and \code{sd} for vectorized prior computation.}
}
\value{
A list with two elements:
\itemize{
\item \code{posterior_vals}, the total log-posterior values (log-likelihood +
log-prior) per chain.
\item \code{log_like_vals}, the log-likelihood components only, per chain.
}
}
\description{
These functions compute conditional log-posterior distributions used in a
(hierarchical) MCMC sampler.
}
\details{
\code{log_posterior_hyper()} computes the conditional log-posterior for a
group-level hyperparameter matrix \code{phi_j_mat}, given
the individual-level parameters across subjects \code{theta_j_mat} (for one
type of model parameter).

\code{log_posterior_lower()} computes the conditional log-posterior for
an individual participant’s parameter matrix \code{thetas_one_subj_mat}, given
prior distributions. In the hierarchical setting, the prior distributions
are conditioned on the group-level parameters.
}
\keyword{internal}
