% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample_cluster.R
\name{sample_cluster}
\alias{sample_cluster}
\title{Cluster sampling}
\usage{
sample_cluster(attribute, n_clusters, seed = NULL)
}
\arguments{
\item{attribute}{cluster attribute name}

\item{n_clusters}{number of clusters to sample}

\item{seed}{optional random seed for reproducibility}
}
\value{
returns an object of class \code{sample_cluster}
}
\description{
Sample entire clusters defined by a categorical attribute.
}
\examples{
data(iris)
sc <- sample_cluster("Species", n_clusters = 2, seed = 123)
iris_sc <- transform(sc, iris)
table(iris_sc$Species)
}
