% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_file_metadata.R
\name{get_file_metadata}
\alias{get_file_metadata}
\title{Retrieve a ddi metadata file}
\usage{
get_file_metadata(
  file,
  dataset = NULL,
  format = c("ddi", "preprocessed"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{file}{An integer specifying a file identifier; or a vector of integers
specifying file identifiers; or, if used with the prefix \code{"doi:"}, a
character with the file-specific DOI; or, if used without the prefix, a
filename accompanied by a dataset DOI in the \code{dataset} argument, or an object of
class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.
Can be a vector for multiple files.}

\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}

\item{format}{Defaults to \dQuote{ddi} for metadata files}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \code{DATAVERSE_SERVER = "dataverse.harvard.edu"} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{...}{Additional arguments passed to an HTTP request function,
such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}. See \code{\link{use_cache}} for details
on how the \emph{R} dataverse package uses disk and session caches to
improve network performance.}
}
\value{
A character vector containing a DDI
metadata file.
}
\description{
Retrieve a ddi metadata file
}
\examples{

\dontrun{
 ddi_raw <- get_file_metadata(file = "nlsw88.tab",
                              dataset = "10.70122/FK2/PPIAXE",
                              server = "demo.dataverse.org")
 xml2::read_xml(ddi_raw)
}

}
