% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_age_standardise.R
\name{direct_age_standardise}
\alias{direct_age_standardise}
\title{Direct Age Standardisation with Confidence Intervals}
\usage{
direct_age_standardise(
  data,
  var,
  ageband,
  observed,
  population,
  multiplier = 1000
)
}
\arguments{
\item{data}{Dataframe with observed values and population}

\item{var}{One or more grouping variables (quoted or unquoted)}

\item{ageband}{Column specifying age bands}

\item{observed}{Column with observed counts}

\item{population}{Column with denominator population}

\item{multiplier}{Scale for rates (default = 1,000)}
}
\value{
A tibble with directly standardised rates and 95\% confidence intervals
}
\description{
Computes directly age-standardised rates with 95\% confidence intervals
using the 2013 European Standard Population and Byar’s method.
}
\examples{
example_data <- data.frame(
  variable = c("A", "A", "B", "B"),
  ageband = c("0-4", "5-9", "0-4", "5-9"),
  observed = c(10, 20, 15, 25),
  population = c(1000, 1200, 1100, 1300)
)

direct_age_standardise(
  data = example_data,
  var = "variable",
  ageband = "ageband",
  observed = "observed",
  population = "population"
)

}
