% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_truncated.R
\name{dist_truncated}
\alias{dist_truncated}
\title{Truncate a distribution}
\usage{
dist_truncated(dist, lower = -Inf, upper = Inf)
}
\arguments{
\item{dist}{The distribution(s) to truncate.}

\item{lower, upper}{The range of values to keep from a distribution.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Note that the samples are generated using inverse transform sampling, and the
means and variances are estimated from samples.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_truncated.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_truncated.html}

In the following, let \eqn{X} be a truncated random variable with
underlying distribution \eqn{Y}, truncation bounds \code{lower} = \eqn{a} and
\code{upper} = \eqn{b}, where \eqn{F_Y(x)} is the c.d.f. of \eqn{Y} and
\eqn{f_Y(x)} is the p.d.f. of \eqn{Y}.

\strong{Support}: \eqn{[a, b]}

\strong{Mean}: For the general case, the mean is approximated numerically.
For a truncated Normal distribution with underlying mean \eqn{\mu} and
standard deviation \eqn{\sigma}, the mean is:

\deqn{
    E(X) = \mu + \frac{\phi(\alpha) - \phi(\beta)}{\Phi(\beta) - \Phi(\alpha)} \sigma
  }{
    E(X) = mu + (phi(alpha) - phi(beta)) / (Phi(beta) - Phi(alpha)) * sigma
  }

where \eqn{\alpha = (a - \mu)/\sigma}, \eqn{\beta = (b - \mu)/\sigma},
\eqn{\phi} is the standard Normal p.d.f., and \eqn{\Phi} is the
standard Normal c.d.f.

\strong{Variance}: Approximated numerically for all distributions.

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \begin{cases}
      \frac{f_Y(x)}{F_Y(b) - F_Y(a)} & \text{if } a \le x \le b \\
      0 & \text{otherwise}
    \end{cases}
  }{
    f(x) = f_Y(x) / (F_Y(b) - F_Y(a)) if a <= x <= b, 0 otherwise
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = \begin{cases}
      0 & \text{if } x < a \\
      \frac{F_Y(x) - F_Y(a)}{F_Y(b) - F_Y(a)} & \text{if } a \le x \le b \\
      1 & \text{if } x > b
    \end{cases}
  }{
    F(x) = 0 if x < a, (F_Y(x) - F_Y(a)) / (F_Y(b) - F_Y(a)) if a <= x <= b, 1 if x > b
  }

\strong{Quantile function}:

\deqn{
    Q(p) = F_Y^{-1}(F_Y(a) + p(F_Y(b) - F_Y(a)))
  }{
    Q(p) = F_Y^(-1)(F_Y(a) + p(F_Y(b) - F_Y(a)))
  }

clamped to the interval \eqn{[a, b]}.
}
\examples{
dist <- dist_truncated(dist_normal(2,1), lower = 0)

dist
mean(dist)
variance(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

if(requireNamespace("ggdist")) {
library(ggplot2)
ggplot() +
  ggdist::stat_dist_halfeye(
    aes(y = c("Normal", "Truncated"),
        dist = c(dist_normal(2,1), dist_truncated(dist_normal(2,1), lower = 0)))
  )
}

}
