% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{geom_set}
\alias{geom_set}
\title{Set document geometry defaults}
\usage{
geom_set(...)
}
\arguments{
\item{...}{Series of named value pairs for latex geometry options}
}
\value{
Named list
}
\description{
Set document geometry defaults
}
\details{
Type geom_set() in console to view package defaults. Use of the
function will add to the defaults and/or override included defaults of the
same name. For values that are \code{NULL}, such as for \code{headheight} and
\code{footskip}, the values will be calculated automatically based on the number
of header and/or footer lines. For all geometry settings, reference the
documentation here: https://texdoc.org/serve/geometry.pdf/0
}
\examples{
# view defaults
geom_set()

# Update the defaults
geom_set(left="0.5in", right="0.5in")

# add new defaults
geom_set(paper = "legalpaper")

}
