% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_draw_ht.R
\name{compute_layout}
\alias{compute_layout}
\title{Compute Layout Dimensions for Tree + Heatmap Plot}
\usage{
compute_layout(
  sorted_dat,
  margin = 20,
  total_w = 297,
  total_h = 210,
  tree_p = 0.3
)
}
\arguments{
\item{sorted_dat}{List returned by \code{sorted_mat()}. Must contain \code{sorted_test_matrix}.}

\item{margin}{Numeric. Margin around the drawing area (mm).}

\item{total_w}{Numeric. Total width of page (mm).}

\item{total_h}{Numeric. Total height of page (mm).}

\item{tree_p}{Numeric. Proportion of total width allocated to the tree panel.}
}
\value{
A list with:
\item{tree_w}{Width for tree panel.}
\item{heatmap_w}{Width for heatmap panel.}
\item{total_draw_h}{Total drawable height after margin.}
\item{row_h}{Height allocated to rows.}
\item{col_h}{Height allocated to columns.}
\item{tree_h}{Height for tree panel (same as row_h).}
\item{offset_h}{Adjustment applied to ensure minimum column height.}
\item{margin}{Margin passed through.}
}
\description{
Determines panel widths and heights based on page dimensions, margin, and proportions.
}
\keyword{internal}
