% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_tree.R
\name{eval_tree}
\alias{eval_tree}
\title{Evaluate Tree Model Predictions and Metrics}
\usage{
eval_tree(
  x = NULL,
  fit = NULL,
  task = c("classification", "regression"),
  tree_res = NULL,
  target_lab = NULL,
  sorted_dat = NULL,
  show = c("all", "train", "test"),
  model = c("rpart", "party", "C50", "caret", "cforest"),
  col_proximity = c("pearson", "spearman", "kendall"),
  linkage_method = c("CT", "SG", "CP"),
  seriate_method = "TSP",
  simple_metrics = FALSE
)
}
\arguments{
\item{x}{Character. Name or label of the dataset.}

\item{fit}{A fitted partykit tree object used to extract split variables.}

\item{task}{Character. Type of task: "classification" or "regression".}

\item{tree_res}{List. Output from \code{compute_tree()}}

\item{target_lab}{Character. Name of the target column in \code{tree_res$dat}.}

\item{sorted_dat}{List. Output from \code{sorted_mat()}.}

\item{show}{Character. "train","test", or "all" to select subset before sorting.}

\item{model}{Character. Identifier for the model method (e.g., "rpart").}

\item{col_proximity}{Character. Correlation method: "pearson","spearman","kendall".}

\item{linkage_method}{Character. Linkage for supervised distance: "CT","SG","CP".}

\item{seriate_method}{Character. Seriation method for distance objects; see
\code{seriation::list_seriation_methods("dist")} for all supported options. Default: \code{"TSP"}.}

\item{simple_metrics}{Logical. If TRUE, use simple metric summary instead of full confusion matrix (default FALSE).}
}
\value{
A list with elements:
\item{data_info}{Character summary of dataset name, sizes, methods, and scores.}
\item{train_metrics}{Character output of the train confusion matrix (if applicable).}
\item{test_metrics}{Character output of the test confusion matrix (if applicable).}
}
\description{
Generates summary information and confusion matrix metrics for training and/or test subsets
based on a fitted decision tree and sorted matrix results.
}
\examples{
\donttest{
library(rpart)
library(partykit)
library(ggparty)
library(dplyr)
library(seriation)
data_all <- add_data_type(
  data_train = train_covid, data_test = test_covid
)
data <- prepare_features(
  data_all,
  target_lab = "Outcome",
  task = "classification"
)
train_tree <- train_tree(
  data_train = train_covid,
  target_lab = "Outcome", model = "rpart"
)
fit <- train_tree$fit
var_imp <- train_tree$var_imp
tree_res <- compute_tree(
  fit,
  model = "rpart", show = "test",
  data = data, target_lab = "Outcome",
  task = "classification"
)
sorted_dat <- sorted_mat(
  tree_res,
  target_lab = "Outcome", show = "test"
)
# Case 1: Pass the dataset name
eval_tree(
  x = "covid", fit = fit,
  task = "classification",
  tree_res = tree_res,
  target_lab = "Outcome",
  sorted_dat = sorted_dat,
  show = "test", model = "rpart"
)
}
}
