% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_delta.R
\name{dtms_delta}
\alias{dtms_delta}
\title{Calculate delta}
\usage{
dtms_delta(
  data,
  dtms = NULL,
  model1 = NULL,
  model2 = NULL,
  lags = 1:5,
  controls = NULL,
  fromvar = "from",
  tovar = "to",
  timevar = "time",
  idvar = "id",
  reference = 1,
  package = "VGAM",
  full = FALSE,
  keepNA = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{model1}{Name of object containing a model estimated with \code{dtms_fit}.}

\item{model2}{Name of object containing a model estimated with \code{dtms_fit}.}

\item{lags}{Numeric (optional), vector containing the lags as positive integers.}

\item{controls}{Character (optional), names of control variables}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is "from".}

\item{tovar}{Character (optional), name of variable in `data` with receiving state. Default is "to".}

\item{timevar}{Character (optional), name of variable in `data` with time scale. Default is "time".}

\item{idvar}{Character (optional), name of variable in `data` with unit ID. Default is "id".}

\item{reference}{Numeric or character (optional). Reference level of multinomial logistic regression.}

\item{package}{Character, chooses package for multinomial logistic regression, currently `VGAM`, `nnet`, and `mclogit` are supported. Default is `VGAM`.}

\item{full}{Logical (optional), estimate fully interacted model? Default is FALSE.}

\item{keepNA}{Logical (optional), keep missing values of lags as predictor value? Default is TRUE.}

\item{...}{Further arguments passed to estimation functions.}
}
\value{
Vector of values of delta
}
\description{
Calculates delta, either to compare transition probabilities from two
different models, or to assess how including lags changes transition
probabilities.
}
\details{
Delta is the weighted average absolute difference between the predicted
transition probabilities from two multistate models. It can attain values
between 0 and 1, where 0 indicates perfect similarity and 1 indicates that
the two models always give predictions at the opposite extremes; i.e., for
all predicted probabilities, one model predicts a probability of 0 and the
other predicts a probability of 1.

This function is designed to use delta to assess the impact of including
different lags of the state variable in the model.

To compare two different models, the arguments `data`, `model1`, and `model2`
are needed. `data` specifies the data frame used for predicting transition
probabilities. It needs to have all variables required for predicting based
on both `model1` and `model2`. The latter two arguments are the names of
multistate models estimated with \code{dtms_fit}.

To compare how the inclusion of different lags of the state variable affects
predictions, a model needs to be specified using `data` and `dtms`, as well
as potential covariates with `controls`. The argument `lags` sets which lags
are included These are always including lower lags; e.g., a model including
the state at t-3 also has the state at t-2, at t-1, and at t. All resulting
models are compared to a model which does not control for the current or any
past state. If `lags=NULL` the Markov model is compared to this model not
accounting for the current state or any past states.

The argument `keepNA` controls how missing values are handled. These will
often occur for lagged states. For instance, for the first transition
observed for an individual, the state at time t is known, but not at time
t-1. In this case, if a first-order lag is used, this observation could either
be dropped; or, a missing value of the state at time t-1 could be included
as a predictor. `keepNA=TRUE` will do the latter, while if `FALSE`, all
observations with missing states are dropped. This is done for all
models, irrespective of the lag, such that they are based on exactly the
same observations.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit models
fit1 <- dtms_fit(data=estdata,controls="time")
fit2 <- dtms_fullfit(data=estdata,controls="time")

## Compare
dtms_delta(data=estdata,model1=fit1,model2=fit2)
}
