% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_simulate.R
\name{dtms_simulate}
\alias{dtms_simulate}
\title{Simulation of Markov chains}
\usage{
dtms_simulate(
  probs = NULL,
  matrix = NULL,
  dtms,
  size = 100,
  start_distr = NULL,
  droplast = TRUE,
  varnames = "T_"
)
}
\arguments{
\item{probs}{Data frame with transition probabilities, as created with \code{dtms_transitions}.}

\item{matrix}{Matrix, a matrix of transition probabilities as created with \code{dtms_matrix()},}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{size}{Numeric, number of trajectories which will be simulated. Default is 100.}

\item{start_distr}{Numeric (optional), distribution of starting states. If NULL, starting states will be assumed to be equally distributed.}

\item{droplast}{Logical (optional), drop final time step after the time scale in which every unit is absorbed? Default is TRUE.}

\item{varnames}{Character (optional), suffix for variable names in simulated data. Will be pasted with values of the timescale. Default is "T_".}
}
\value{
A data frame with simulated trajectories in wide format.
}
\description{
This function simulates trajectories based on a Markov chain using the
`markovchain` package.
}
\examples{
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:19)
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
fit <- dtms_fit(data=estdata,package="mclogit")
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
dtms_simulate(probs=probs,dtms=simple)
}
