% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_start.R
\name{dtms_start}
\alias{dtms_start}
\title{Tabulate starting distribution}
\usage{
dtms_start(
  data,
  dtms,
  variables = NULL,
  start_state = NULL,
  start_time = NULL,
  fromvar = "from",
  timevar = "time",
  weights = NULL
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{variables}{List (optional), a named list with covariate values which are used to restrict the data.}

\item{start_state}{Character (optional), name of starting states. If NULL (default) all transient states will be used.}

\item{start_time}{Numeric (optional), value of time scale for start. If several values are specified, the average distribution over all these values is calculated. In this case the first value specified with this argument is used to construct the long state name. If NULL (default) first value of time scale will be used.}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is `from`.}

\item{timevar}{Character (optional), name of variable in `data` with time scale. Default is `time`.}

\item{weights}{Character (optional). Name of variable with survey weights.}
}
\value{
Returns a table of the starting distribution.
}
\description{
Tabulates the starting distribution.
}
\details{
Per default, the starting distribution is the distribution of transient
states at the first value of the time scale in the data. This can be
changed to any value of the time scale, and any set of states. The
distribution can also be conditional on further covariate values which can be
specified with the argument `variables`.

`variables` takes a named list where each entry of the list is named like
the corresponding variable and with the values to be selected.
}
\examples{
work <- dtms(transient=c("Working","Non-working","Retired"),
             absorbing="Dead",
             timescale=50:99)
## Reshape
estdata <- dtms_format(data=workdata,
                       dtms=work,
                       idvar="ID",
                       timevar="Age",
                       statevar="State")
## Drop dead-to-dead transitions etc
estdata <- dtms_clean(data=estdata,
                      dtms=work)
## Starting distributions
# Men
Sm <- dtms_start(dtms=work,
                 data=estdata,
                 variables=list(Gender=0))
# Women
Sw <- dtms_start(dtms=work,
                 data=estdata,
                 variables=list(Gender=1))
}
