# Generated by 02-duckplyr_df-methods.R
#' @export
group_modify.duckplyr_df <- function(.data, .f, ..., .keep = FALSE, keep = deprecated()) {
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_modify(keep = )", "group_modify(.keep = )", always = TRUE)
    .keep <- keep
  }

  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code group_modify()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  group_modify <- dplyr$group_modify.data.frame
  out <- group_modify(.data, .f, ..., .keep = .keep)
  return(out)

  # dplyr implementation
  if (!missing(keep)) {
    lifecycle::deprecate_stop(
      "1.0.0",
      "group_modify(keep = )",
      "group_modify(.keep = )"
    )
  }
  .f <- as_group_map_function(.f)
  .f(.data, group_keys(.data), ...)
}

duckplyr_group_modify <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_modify(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
