% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_chord}
\alias{e_chord}
\alias{e_chord_}
\title{Chord}
\usage{
e_chord(e, source, target, value, rm_x = TRUE, rm_y = TRUE, ...)

e_chord_(e, source, target, value, rm_x = TRUE, rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{source, target}{Source and target columns.}

\item{value}{Value shared between \code{source} and \code{target}.}

\item{rm_x, rm_y}{Whether to remove the x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw a Chord chart.
}
\examples{
chord_data <- data.frame(
  source = c("a", "b", "c", "d", "c"),
  target = c("b", "c", "d", "e", "e"),
  value = ceiling(rnorm(5, 10, 1)),
  stringsAsFactors = FALSE
)

chord_data |>
  e_charts() |>
  e_chord(source, target, value)
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-chord}{Additional arguments}
}
